/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.command;

import com.ibm.hsc.command.ControllerThreadPool;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Date;
import java.util.Properties;

public class CommandController {
    private static final String LOCAL_HOST = "127.0.0.1";
    private static final int COMMAND_LISTENER_SOCKET = 6198;
    private static final String PROPERTIES_FILE = "/opt/hsc/data/CommandController.properties";
    private static final String PROPERTY_ERROR = "PROPRTY ERROR: ";
    private static final String DEFAULT_LOG_FILE = "/var/hsc/log/controller.log";
    private static final String DEV_NULL = "/dev/null";
    private static final int DEFAULT_INITIAL_THREADS = 5;
    private static final int DEFAULT_MAX_THREADS = 20;
    private static final String THREAD_MAX_PROPERTY = "thread.max";
    private static final String THREAD_INITIAL_PROPERTY = "thread.initial";
    private static final String LOG_FILE_PROPERTY = "log.file";
    public static PrintStream log;

    private static void openLogFile(String string) {
        FileOutputStream fileOutputStream = null;
        if (null != string) {
            try {
                fileOutputStream = new FileOutputStream(string);
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.out.println("Unable to create controller log file: " + string);
                System.out.println("Using default = /var/hsc/log/controller.log");
            }
        }
        if (null == fileOutputStream) {
            try {
                fileOutputStream = new FileOutputStream(DEFAULT_LOG_FILE);
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.out.println("Unable to create controller default log file: /var/hsc/log/controller.log");
            }
        }
        if (null == fileOutputStream) {
            try {
                fileOutputStream = new FileOutputStream(DEV_NULL);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        log = new PrintStream(fileOutputStream);
        System.setErr(log);
        System.setOut(log);
        long l = System.currentTimeMillis();
        Date date = new Date(l);
        log.println("Started: " + date.toString() + " - " + l);
    }

    private static void readControllerProperties() {
        int n;
        int n2;
        Properties properties = new Properties();
        try {
            FileInputStream fileInputStream = new FileInputStream(PROPERTIES_FILE);
            properties.load(fileInputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Controller properties file - not found: /opt/hsc/data/CommandController.properties");
        }
        catch (IOException iOException) {
            System.out.println("Unable to load properties file - using defaults");
        }
        CommandController.openLogFile(properties.getProperty(LOG_FILE_PROPERTY));
        String string = properties.getProperty(THREAD_MAX_PROPERTY);
        if (null == string) {
            n2 = 20;
        } else {
            try {
                n2 = new Integer(string);
            }
            catch (NumberFormatException numberFormatException) {
                log.println("PROPRTY ERROR: invalid max thread value: " + string + "Using default max thread value = " + 20);
                n2 = 20;
            }
        }
        string = properties.getProperty(THREAD_INITIAL_PROPERTY);
        if (null == string) {
            n = 5;
        } else {
            try {
                n = new Integer(string);
            }
            catch (NumberFormatException numberFormatException) {
                log.println("PROPERTY ERROR: invalid initial thread value: " + string + "Using default initial thread value = " + 5);
                n = 5;
            }
        }
        if (n > n2) {
            log.println("PROPRTY ERROR: initial thread count is greater than maximum thread count");
            log.println("Resetting initial thread = maximum thread = " + n2);
        }
        log.println("Maximum Thread Count = " + n2 + "\nInitial Thread Count = " + n);
        ControllerThreadPool.create(n, n2);
    }

    private static void acceptRequests() {
        ServerSocket serverSocket;
        int n = 0;
        try {
            log.println("listening on port = 6198");
            serverSocket = new ServerSocket(6198);
        }
        catch (IOException iOException) {
            log.println("ERROR: unable to open listener socket");
            log.println(iOException.getMessage());
            iOException.printStackTrace(log);
            return;
        }
        while (true) {
            try {
                while (true) {
                    Socket socket = serverSocket.accept();
                    ++n;
                    String string = socket.getInetAddress().getHostAddress();
                    if (string.equals(LOCAL_HOST)) {
                        ControllerThreadPool.newRequest(socket);
                        continue;
                    }
                    socket.close();
                    log.println("CONNECTION REJECTED: " + string + "  " + new Date(System.currentTimeMillis()).toString());
                }
            }
            catch (IOException iOException) {
                log.println(iOException.getMessage());
                iOException.printStackTrace(log);
                continue;
            }
            break;
        }
    }

    public static void main(String[] stringArray) {
        CommandController.readControllerProperties();
        CommandController.acceptRequests();
        System.exit(0);
    }
}

